function [hs1,hs2,hs3]=panel_day(timestamp,Vh,theta,w,height)


date_time=datestr(timestamp(1),'yyyy-mm-dd');
tvec=datevec(timestamp);
dtime=tvec(:,4)+(tvec(:,5)+tvec(:,6)/60)/60;
h=[50:10:1500];
% hs=figure('Position',[50 50 1000 800]);
% cp1=colormap(copper(128));
% cp2=colormap(hot(128));
% for j=1:128
%   cc(j,:)=cp1(j,:);
%   cc(256-j,:)=cp2(j,:);
% end
% cc=cmocean('phase',128);

hs1=figure('Position',[50 50 1000 300]);
cc=cmocean('speed',128);
colormap(gca,jet(256))
p1=pcolor(dtime,height,Vh');
set(p1,'edgecolor','none')
xlim([0 24])
set(gca,'Xtick',[0 6 12 18 24])
colorbar
caxis([0 20])
ylabel('Height AGL (m)','FontSize',14)
xlabel('Horizontal Wind Speed (m/s)','FontSize',14)
ht1=title(['Wind Profile for  ',date_time],'FontSize',16)

hs2=figure('Position',[50 50 1000 300]);
cc=cmocean('phase',128);
p2=pcolor(dtime,height,theta');
set(p2,'edgecolor','none')
colormap(gca,cc)
xlim([0 24])
set(gca,'Xtick',[0 6 12 18 24])
caxis([0 360])
colorbar%('YTickLabel',[0 90 180 270 360])
ylabel('Height AGL (m)','FontSize',14)
xlabel('Wind Direction ','FontSize',14)
ht2=title(['Wind Profile for  ',date_time],'FontSize',16)


hs3=figure('Position',[50 50 1000 300]);
cc=cmocean('speed',128);
p3=pcolor(dtime,height,w');
colormap(gca,jet(256))
set(p3,'edgecolor','none')
xlim([0 24])
set(gca,'Xtick',[0 6 12 18 24])
colorbar
caxis([-2 2])
ylabel('Height AGL (m)','FontSize',14)
xlabel('Vertical Wind (m/s) ','FontSize',14)
ht3=title(['Wind Profile for  ',date_time],'FontSize',16)

end